/*
 * MPIparalelization.cpp
 *
 *  Created on: Nov 19, 2013
 *      Author: nino
 */

#include <MPIparalelization.h>


/**
 * Disaptches the tasks (initial sources) to workers from nodes_set (single sources are coded only)
 */
int master_process_likelihood_singles(int mpi_size, int mpi_rank, int no_of_nodes_set, int * nodes_set, int source_node_id) {

    BOOLEAN do_work = TRUE;
    int no_of_proc_finished = 0;
    int no_of_free_tasks = no_of_nodes_set;
    int next_task_index = 0;
    int request[REQ_SIZE];
    int i;

	MPI_Bcast( &source_node_id, 1, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);
	MPI_Bcast( &no_of_nodes_set, 1, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);
	MPI_Bcast ( nodes_set, no_of_nodes_set, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);
	MPI_Barrier(MPI_COMM_WORLD);

    while ( do_work ) {

        MPI_Status status;
        // primi zahtjev
        MPI_Recv(&request, REQ_SIZE, MPI_INT, MPI_ANY_SOURCE, TAG_WORKER_MASTER, MPI_COMM_WORLD, &status);

        if ( request[0] == REQ_GIVE_DATA ) {
            int answer[ANS_SIZE];
            if ( no_of_free_tasks == 0 ) {
                no_of_proc_finished++;
                answer[0] = ANS_STOP_WORK;
            }else{
                answer[0] = ANS_CONTINUE_WORK;
                int ans_data_index = 1;
                for(int i = next_task_index; i < (next_task_index + ANS_DATA_SIZE); ++i){
                    if ( i < no_of_nodes_set){
                        answer[ans_data_index++] = nodes_set[i];
                        no_of_free_tasks--;
                    }else {
                        answer[ans_data_index++] = -1 ;
                    }
                }
                next_task_index += ANS_DATA_SIZE;
            }
            MPI_Send(&answer, ANS_SIZE , MPI_INT, status.MPI_SOURCE, TAG_MASTER_WORKER, MPI_COMM_WORLD);
        }
        if( no_of_proc_finished >= (mpi_size-2)) {
			// -2 ako se koristi i colllector process, inace -2
            do_work = FALSE;
        }
    }
    return mpi_rank;
}

/*
int collector_process_likelihood_singles(input* input_args, infected_structure * p_infected_parameters, int mpi_rank, statistics * statistic_parameters ,  int realization_id ){

	int source_node_id;
	MPI_Bcast( &source_node_id, 1, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);
	p_infected_parameters->start_node = source_node_id; // now we know who is the source node, since master defines the source node

	int num_realization_nodes;
	MPI_Bcast( &num_realization_nodes, 1, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);
	//printf("source %d, realization_size %d ", source_node_id, num_realization_nodes);
	statistic_parameters->realization_size = num_realization_nodes;

	int * realization_star_list = (int *)  malloc(num_realization_nodes * sizeof(int)); // *** HEAP MEMORY SAFE
	MPI_Bcast ( realization_star_list, num_realization_nodes ,MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);

	MPI_Barrier(MPI_COMM_WORLD);

	igraph_vector_t realization_star; // *** HEAP MEMORY SAFE
	igraph_vector_init ( &realization_star, p_infected_parameters->no_of_nodes);
	for(int i = 0; i < num_realization_nodes ; ++i){
		VECTOR(realization_star)[ (realization_star_list[i]) ] = 1;
	}

	int workerResultSize = 5;
	double * workerResult = (double *) malloc( workerResultSize * sizeof(double)); // *** HEAP MEMORY SAFE
	// workerResult[0] - node_id
	// workerResult[1] - node_id likelihood score
	// workerResult[2] - realization_size
	// workerResult[3] - node_id distance from source star
	// workerResult[4] - source star node

	//clear data
	for( int i = 0 ; i< p_infected_parameters->no_of_nodes ;++i){
		statistic_parameters->likelihoodAll[i] = 0.0;
	}

	for( int i = 0; i < num_realization_nodes; ++i){
		MPI_Status status;
        // primi zahtjev
        MPI_Recv(workerResult, workerResultSize, MPI_DOUBLE, MPI_ANY_SOURCE, TAG_DOUBLE_WORKER_COLLECTOR, MPI_COMM_WORLD, &status);
		//scoreAll[ (int) workerResult[0] ] = workerResult[1];
        statistic_parameters->likelihoodAll[ (int) workerResult[0] ] = workerResult[1];
	}


	free(realization_star_list);
	igraph_vector_destroy(&realization_star);
	free(workerResult);

	return mpi_rank;

}
*/

int collector_process_likelihood_singles(input* input_args, infected_structure * p_infected_parameters, int mpi_rank, statistics * statistic_parameters ,  int realization_id, likelihood_struct * likelihood_tmp ){

	int source_node_id;
	MPI_Bcast( &source_node_id, 1, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);
	p_infected_parameters->start_node = source_node_id; // now we know who is the source node, since master defines the source node

	int num_realization_nodes;
	MPI_Bcast( &num_realization_nodes, 1, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);
	//printf("source %d, realization_size %d ", source_node_id, num_realization_nodes);
	statistic_parameters->realization_size = num_realization_nodes;

	int * realization_star_list = (int *)  malloc(num_realization_nodes * sizeof(int)); // *** HEAP MEMORY SAFE
	MPI_Bcast ( realization_star_list, num_realization_nodes ,MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);

	MPI_Barrier(MPI_COMM_WORLD);

	igraph_vector_t realization_star; // *** HEAP MEMORY SAFE
	igraph_vector_init ( &realization_star, p_infected_parameters->no_of_nodes);
	for(int i = 0; i < num_realization_nodes ; ++i){
		VECTOR(realization_star)[ (realization_star_list[i]) ] = 1;
	}



	int workerResultSize = 5;
	if (likelihood_tmp->likelihood_method == LIKELIHOOD_METHOD_SOFT_MARGIN_A_RANGE){ //we are sending the set of likelihoods for a range !!!
		workerResultSize += likelihood_tmp->a_array.size() + likelihood_tmp->likelihood_theta_a_array.size();

		//clear results
		for (int a_idx = 0; a_idx < likelihood_tmp->a_array.size(); ++a_idx){
			for (int i = 0 ; i < p_infected_parameters->no_of_nodes; ++i){
				statistic_parameters->a_array_likelihoods.at(a_idx)[i]  = 0.0;
			}
		}
	}
	double * workerResult = (double *) malloc( workerResultSize * sizeof(double)); // *** HEAP MEMORY SAFE
	// workerResult[0] - node_id
	// workerResult[1] - node_id likelihood score
	// workerResult[2] - realization_size
	// workerResult[3] - node_id distance from source star
	// workerResult[4] - source star node

	//clear data
	for( int i = 0 ; i< p_infected_parameters->no_of_nodes ;++i){
		statistic_parameters->likelihoodAll[i] = 0.0;
		VECTOR(*(statistic_parameters->observed_realization))[i] = 0;
		if (VECTOR(realization_star)[i] == 1){
			VECTOR(*(statistic_parameters->observed_realization))[i] = 1;
		}
	}

	for( int i = 0; i < num_realization_nodes; ++i){
		MPI_Status status;
        // primi zahtjev
        MPI_Recv(workerResult, workerResultSize, MPI_DOUBLE, MPI_ANY_SOURCE, TAG_DOUBLE_WORKER_COLLECTOR, MPI_COMM_WORLD, &status);
		//scoreAll[ (int) workerResult[0] ] = workerResult[1];
        statistic_parameters->likelihoodAll[ (int) workerResult[0] ] = workerResult[1];

        if (likelihood_tmp->likelihood_method == LIKELIHOOD_METHOD_SOFT_MARGIN_A_RANGE){
			int worker_results_idx = 5;
			//we append the following data (a_1,likelihood_a_1, a_2, likelihood_a_2,....)
			for (int a_idx = 0; a_idx < likelihood_tmp->a_array.size(); ++a_idx){
				statistic_parameters->a_array.at(a_idx) = workerResult[worker_results_idx++];
				statistic_parameters->a_array_likelihoods.at(a_idx)[(int) workerResult[0]]  = workerResult[worker_results_idx++];
			}
		}
	}


	free(realization_star_list);
	igraph_vector_destroy(&realization_star);
	free(workerResult);

	return mpi_rank;

}

int worker_process_likelihood_singles(int mpi_rank, input* input_args, infected_structure * p_infected_parameters, statistics * statistic_parameters, contagion_param_struct * epidemicParameters_exp, likelihood_struct * likelihood_tmp)
{
    MPI_Status status;

    int answer[ANS_SIZE];
    BOOLEAN do_work = TRUE;

	int source_node_id;
	MPI_Bcast( &source_node_id, 1, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);

	int num_realization_nodes;
	MPI_Bcast( &num_realization_nodes, 1, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);

	int * realization_star_list = (int *)  malloc(num_realization_nodes * sizeof(int)); //***HEAP-MEMORY SAFE
	MPI_Bcast ( realization_star_list, num_realization_nodes, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);

    MPI_Barrier(MPI_COMM_WORLD);

	igraph_vector_t realization_star; //***HEAP-MEMORY SAFE
	igraph_vector_init ( &realization_star, p_infected_parameters->no_of_nodes);
	for(int i = 0; i < num_realization_nodes ; ++i){
		VECTOR(realization_star)[ (realization_star_list[i]) ] = 1;
	}

	statistic_parameters->observed_realization = &realization_star;

	igraph_matrix_t * geodesic_paths; //***HEAP-MEMORY SAFE
	if ( CALC_SHORTEST_PATHS_WORKERS == 1){
		geodesic_paths = (igraph_matrix_t *) malloc(sizeof(igraph_matrix_t));
		igraph_matrix_init( geodesic_paths, 1, p_infected_parameters->no_of_nodes);
		//igraph_shortest_paths(p_infected_parameters->p_graph, geodesic_paths, igraph_vss_1((igraph_integer_t) source_node_id), IGRAPH_ALL);

		#ifdef IGRAPH_VERSION_0_6_5
		igraph_shortest_paths( p_infected_parameters->p_graph, geodesic_paths, igraph_vss_1((igraph_integer_t) source_node_id), igraph_vss_all(), IGRAPH_ALL);
		#else
		igraph_shortest_paths( p_infected_parameters->p_graph, geodesic_paths, igraph_vss_1((igraph_integer_t) source_node_id), IGRAPH_ALL);
		#endif
	}

	int workerResultSize = 5;
	if (likelihood_tmp->likelihood_method == LIKELIHOOD_METHOD_SOFT_MARGIN_A_RANGE){ //we are sending the set of likelihoods for a range !!!
		workerResultSize += likelihood_tmp->a_array.size() + likelihood_tmp->likelihood_theta_a_array.size();
	}
	double * workerResult = (double *) malloc( workerResultSize * sizeof(double)); //***HEAP-MEMORY SAFE

    while ( do_work ) {
        int request[REQ_SIZE];
        request[0] = REQ_GIVE_DATA;
        MPI_Send(&request, REQ_SIZE, MPI_INT, MASTER_PROCESS_ID, TAG_WORKER_MASTER, MPI_COMM_WORLD);
		// waiting fo answer
        MPI_Recv(&answer, ANS_SIZE, MPI_INT, MASTER_PROCESS_ID, TAG_MASTER_WORKER, MPI_COMM_WORLD, &status);
        if (answer[0] == ANS_CONTINUE_WORK) {
            for(int i = 1; i < ANS_SIZE; ++i ) {
                if ( answer[i] != -1 ) {
                    p_infected_parameters->start_node = (long int) answer[i];

					double tmpLogLikelihood;
					tmpLogLikelihood = calculate_realization_likelihood( statistic_parameters, p_infected_parameters, epidemicParameters_exp, likelihood_tmp);
					//printf("wrk: %lf ", tmpLogLikelihood);fflush(stdout);

					workerResult[0]=(double) answer[i];
					workerResult[1]= (double) tmpLogLikelihood;
					workerResult[2]=(double) igraph_vector_size(&realization_star);
					if ( CALC_SHORTEST_PATHS_WORKERS == 1){
						workerResult[3]=(double) MATRIX( *geodesic_paths, 0, (int) answer[i] );
					}else{
						workerResult[3]=(double) -1.0;
					}
					workerResult[4]= (double) source_node_id;

					if (likelihood_tmp->likelihood_method == LIKELIHOOD_METHOD_SOFT_MARGIN_A_RANGE){
						int worker_results_idx = 5;
						//we append the following data (a_1,likelihood_a_1, a_2, likelihood_a_2,....)
						for (int a_idx = 0; a_idx < likelihood_tmp->likelihood_theta_a_array.size(); ++a_idx){
							workerResult[worker_results_idx++] = likelihood_tmp->a_array.at(a_idx);
							workerResult[worker_results_idx++] = likelihood_tmp->likelihood_theta_a_array.at(a_idx);
							//printf("BALON %lf ", likelihood_tmp->likelihood_theta_a_array.at(a_idx));
						}
					}

					MPI_Send(workerResult, workerResultSize, MPI_DOUBLE, COLLECTOR_PROCESS_ID, TAG_DOUBLE_WORKER_COLLECTOR, MPI_COMM_WORLD);

                }
            }
        } else if( answer[0] == ANS_STOP_WORK ) {
            do_work = FALSE;
        }
    }

    if ( CALC_SHORTEST_PATHS_WORKERS == 1){
    	igraph_matrix_destroy( geodesic_paths );
    }
    igraph_vector_destroy( &realization_star );
    statistic_parameters->observed_realization = NULL;
    free(realization_star_list);
    free(workerResult);
    return mpi_rank;
}
